#include <stdio.h>
#include "AD18F08.h"
#include "periph.h"
bit Adc_Succee;
void GPIO_Init(void)
{
	TRISA = 0X00;   //PA口配置输出
	TRISB = 0X00;   //PB口配置输出
	
	PORTA = 0X00;	  //PORTA输出低
	PORTB = 0X00;	  //PORTB输出低
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关闭PA开漏
	PBOD = 0X00;    //关闭PB开漏
	
	ANASEL0 = 0X00; //关闭PA模拟通道
	ANASEL1 = 0X00; //关闭PB模拟通道
}



unsigned short ADC_SampleFilter(void)
{
   unsigned char  j;
   unsigned short Volt       = 0;
   unsigned char  Time_Out   = 0;
 
   for(j = 0;j<=5;j++)
   {
          GO = 1;                         //A/D转换状态位
          Time_Out = 100;                 //设置超时时间
          while(GO)                       //A/D转换正在进行
          {
            Adc_Succee = 0;
            Time_Out--;              //等待超时
            if(Time_Out == 0)        //防止程序跑到这里死掉了
            {
                ADON = 0;         //除能A/D转换器模块
                GO = 0;           //清除转换标志
                ADON = 1;         //使能能A/D转换器模块
                GO = 1;           //清除转换标志
                Adc_Succee = 1;
                break;
            }
          }
   }
   if(Adc_Succee == 0)
   {
        Volt = (ADRESH<<8)|ADRESL;//读取ADC采集值
   }
   else
   {
        Volt = 0xFFFF;
   }
   return Volt;
}
/*

*/
void ADC_Config(void)
{
	TRISB6 = 1;PB6PD = 1;PB6PU = 1;PB6OD = 0;PB6AEN = 1;
	ADCON0 = 0X01;  //配置PB6为ADC采集通道，使能A/D模拟使能位
	ADCON1 = 0XBE;  //参考电压选择VDD   A/D转换时钟选择FOSC/64(ADSP=1)
}
